setwd("your directory or folder path")
df1 <- read.csv("20190923 Example 3.2 Data for Bootstrap.csv")

p.boot.25 <- c()
p.boot.75 <- c()
IQR <- c()
#
#

attach(df1)
bootn <- 2000
#
# Variable
# Y = continuous variable
#
IQR.75 <- quantile(Y,probs=c(0.75),type=8)
IQR.25 <- quantile(Y,probs=c(0.25),type=8)
IQR.point <- IQR.75 - IQR.25
n.obs <- nrow(df1)

for(i in 1:bootn) {
  boot.Y<- sample(Y,size=n.obs,replace = T)
  p.boot.25[i] <- quantile(boot.Y,probs=c(0.25),type=8)
  p.boot.75[i] <- quantile(boot.Y,probs=c(0.75),type=8)
  IQR[i] <- p.boot.75[i] - p.boot.25[i]

  }
#
# this is a percentile-method bootstrap confidence interval
#
lcl.percentile <- quantile(IQR,probs=c(0.025),type=8)
ucl.percentile <- quantile(IQR,probs=c(0.975),type=8)

IQR.boot <- mean(IQR)
Fe <- ecdf(IQR)
Z0 <- qnorm(Fe(IQR.boot))
Zalpha <- qnorm(0.025)
pL <- pnorm(2*Z0 + Zalpha)
pU <- pnorm(2*Z0 - Zalpha)
lcl.unbiased <- quantile(IQR,probs=c(pL),type=8)
ucl.unbiased <- quantile(IQR,probs=c(pU),type=8)

IQR.point
lcl.percentile
ucl.percentile
IQR.boot
lcl.unbiased
ucl.unbiased
hist(IQR)

df2 <- cbind(IQR) # these are bootstrap samples

write.csv(df2,"20190923 bootstrap sample of percentiles.csv")
